<!-- 2670a58c-dc58-4523-8b44-9f5380d7258a c425f0b2-ceda-4743-922a-aaffb3935e0c -->
# Linkie.dev - Technical Blog & Product Showcase Website

## Project Structure

- Create new Laravel 11 project in `linkie-dev/` directory
- Set up TailwindCSS with Vite
- Configure dark mode theme with specified color palette
- Implement MySQL database with migrations

## Database Schema

### Posts Table

- id, title, slug, excerpt, content, featured_image, category, meta_title, meta_description, published_at, created_at, updated_at

### Products Table

- id, name, slug, description, short_description, price, featured_image, images (JSON), themeforest_url, status, created_at, updated_at

### Contact Submissions Table

- id, name, email, subject, message, created_at, updated_at

## Implementation Steps

### 1. Project Setup

- Initialize Laravel 11 project
- Install and configure TailwindCSS via npm/Vite
- Set up custom Tailwind config with dark theme colors (#121212, #E0E0E0, #00B4D8, #1E3A8A)
- Configure Google Fonts (Inter/Montserrat/Cairo) via CDN
- Set up database connection

### 2. Models & Migrations

- Create `Post` model with migration (title, slug, excerpt, content, featured_image, category, meta fields, published_at)
- Create `Product` model with migration (name, slug, description, short_description, price, featured_image, images JSON, themeforest_url, status)
- Create `Contact` model with migration (name, email, subject, message)
- Add relationships and accessors/mutators

### 3. Routes & Controllers

- **Public Routes**: home, blog (list + single), products (list + single), about, contact
- **Admin Routes**: admin dashboard, posts CRUD, products CRUD (with authentication middleware)
- Create controllers: HomeController, BlogController, ProductController, AboutController, ContactController
- Create admin controllers: AdminPostController, AdminProductController

### 4. Blade Templates (Dark Mode + TailwindCSS)

#### Layout Files

- `layouts/app.blade.php` - Main layout with navigation, footer, dark theme
- `layouts/admin.blade.php` - Admin panel layout

#### Public Pages

- `home.blade.php` - Hero section, latest posts, featured products
- `blog/index.blade.php` - Blog listing with category filters, dark cards
- `blog/show.blade.php` - Single post with SEO meta, related articles
- `products/index.blade.php` - Products grid with dark cards
- `products/show.blade.php` - Single product with images, buy buttons
- `about.blade.php` - About page with dark background
- `contact.blade.php` - Contact form with dark styling

#### Admin Pages

- `admin/dashboard.blade.php` - Admin dashboard
- `admin/posts/*.blade.php` - CRUD forms for posts
- `admin/products/*.blade.php` - CRUD forms for products

#### Components

- `components/navbar.blade.php` - Responsive navigation
- `components/footer.blade.php` - Footer with links
- `components/blog-card.blade.php` - Reusable blog post card
- `components/product-card.blade.php` - Reusable product card

### 5. Styling & Design

- Custom Tailwind config with dark theme colors
- Typography: Bold headings (Inter/Montserrat/Cairo), regular body text
- Hover effects with accent color (#00B4D8)
- Mobile responsive breakpoints
- Comment all Tailwind classes explaining layout choices

### 6. Admin Authentication

- Set up basic authentication (Laravel Breeze or custom)
- Protect admin routes with auth middleware
- Create admin user seeder

### 7. Features

- SEO meta tags for blog posts (Open Graph, Twitter Cards)
- Image upload handling for posts/products (Laravel Storage)
- Slug generation for posts/products
- Category filtering for blog
- Related articles algorithm
- Contact form submission handling

### 8. Future Expansion Notes

- API routes structure (for future API integration)
- Stripe payment integration placeholders
- ThemeForest integration notes
- Store expansion architecture

## File Structure

```
linkie-dev/
├── app/
│   ├── Http/Controllers/
│   │   ├── HomeController.php
│   │   ├── BlogController.php
│   │   ├── ProductController.php
│   │   ├── AboutController.php
│   │   ├── ContactController.php
│   │   └── Admin/
│   │       ├── AdminPostController.php
│   │       └── AdminProductController.php
│   └── Models/
│       ├── Post.php
│       ├── Product.php
│       └── Contact.php
├── database/migrations/
│   ├── create_posts_table.php
│   ├── create_products_table.php
│   └── create_contacts_table.php
├── resources/views/
│   ├── layouts/
│   ├── components/
│   ├── home.blade.php
│   ├── blog/
│   ├── products/
│   ├── about.blade.php
│   ├── contact.blade.php
│   └── admin/
├── routes/
│   └── web.php
├── tailwind.config.js
└── README.md (setup instructions)
```

## Key Design Decisions

- Dark mode first approach (no light mode toggle needed)
- Bold typography for headings using Google Fonts
- Accent color (#00B4D8) for CTAs and hover states
- Mobile-first responsive design
- SEO-friendly URL structure with slugs
- Admin panel with simple CRUD interface

### To-dos

- [ ] Initialize Laravel 11 project and install TailwindCSS with Vite, configure custom dark theme colors
- [ ] Create migrations for posts, products, and contacts tables with all required fields
- [ ] Create Post, Product, and Contact models with relationships and helper methods
- [ ] Set up all public and admin routes, create controllers for each section
- [ ] Create main layout, admin layout, navbar, footer, and reusable card components with TailwindCSS
- [ ] Build home, blog (list + single), products (list + single), about, and contact pages with dark theme
- [ ] Create admin dashboard and CRUD interfaces for posts and products with authentication
- [ ] Implement SEO meta tags, slug generation, related articles, and category filtering
- [ ] Add hover effects, mobile responsiveness, typography styling, and comment all Tailwind classes
- [ ] Create README with setup instructions, admin panel guide, and future expansion notes

