<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    public function index()
    {
        $contacts = Contact::latest()->paginate(20);
        return view('admin.submissions.contacts.index', compact('contacts'));
    }

    public function show(Contact $contact)
    {
        // Mark as read
        if (!$contact->read_at) {
            $contact->update(['read_at' => now()]);
        }
        
        return view('admin.submissions.contacts.show', compact('contact'));
    }

    public function destroy(Contact $contact)
    {
        $contact->delete();
        return redirect()->route('admin.submissions.contacts')
            ->with('success', 'Contact submission deleted');
    }

    public function export(Request $request)
    {
        $contacts = Contact::all();
        
        $filename = 'contacts_export_' . date('Y-m-d_His') . '.csv';
        
        $headers = [
            'Content-Type' => 'text/csv',
            'Content-Disposition' => 'attachment; filename="' . $filename . '"',
        ];
        
        $callback = function() use ($contacts) {
            $file = fopen('php://output', 'w');
            
            // Headers
            fputcsv($file, ['Name', 'Email', 'Subject', 'Message', 'Submitted At', 'Read At']);
            
            // Data
            foreach ($contacts as $contact) {
                fputcsv($file, [
                    $contact->name,
                    $contact->email,
                    $contact->subject ?? '',
                    $contact->message,
                    $contact->created_at->format('Y-m-d H:i:s'),
                    $contact->read_at ? $contact->read_at->format('Y-m-d H:i:s') : 'Unread',
                ]);
            }
            
            fclose($file);
        };
        
        return response()->stream($callback, 200, $headers);
    }
}
