<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Post;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class SeoController extends Controller
{
    public function index()
    {
        return view('admin.seo.index');
    }

    public function generateSitemap(Request $request)
    {
        $posts = Post::published()->get();
        $products = Product::active()->get();
        
        $sitemap = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
        $sitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
        
        // Homepage
        $sitemap .= '  <url>' . "\n";
        $sitemap .= '    <loc>' . url('/') . '</loc>' . "\n";
        $sitemap .= '    <lastmod>' . now()->toAtomString() . '</lastmod>' . "\n";
        $sitemap .= '    <changefreq>daily</changefreq>' . "\n";
        $sitemap .= '    <priority>1.0</priority>' . "\n";
        $sitemap .= '  </url>' . "\n";
        
        // Blog posts
        foreach ($posts as $post) {
            $sitemap .= '  <url>' . "\n";
            $sitemap .= '    <loc>' . route('blog.show', $post->slug) . '</loc>' . "\n";
            $sitemap .= '    <lastmod>' . $post->updated_at->toAtomString() . '</lastmod>' . "\n";
            $sitemap .= '    <changefreq>weekly</changefreq>' . "\n";
            $sitemap .= '    <priority>0.8</priority>' . "\n";
            $sitemap .= '  </url>' . "\n";
        }
        
        // Products
        foreach ($products as $product) {
            $sitemap .= '  <url>' . "\n";
            $sitemap .= '    <loc>' . route('products.show', $product->slug) . '</loc>' . "\n";
            $sitemap .= '    <lastmod>' . $product->updated_at->toAtomString() . '</lastmod>' . "\n";
            $sitemap .= '    <changefreq>weekly</changefreq>' . "\n";
            $sitemap .= '    <priority>0.8</priority>' . "\n";
            $sitemap .= '  </url>' . "\n";
        }
        
        // Static pages
        $staticPages = [
            route('blog.index'),
            route('products.index'),
            route('about.index'),
            route('contact.index'),
        ];
        
        foreach ($staticPages as $page) {
            $sitemap .= '  <url>' . "\n";
            $sitemap .= '    <loc>' . $page . '</loc>' . "\n";
            $sitemap .= '    <lastmod>' . now()->toAtomString() . '</lastmod>' . "\n";
            $sitemap .= '    <changefreq>monthly</changefreq>' . "\n";
            $sitemap .= '    <priority>0.6</priority>' . "\n";
            $sitemap .= '  </url>' . "\n";
        }
        
        $sitemap .= '</urlset>';
        
        // Save to public directory
        File::put(public_path('sitemap.xml'), $sitemap);
        
        return redirect()->back()->with('success', 'Sitemap generated successfully!');
    }

    public function analyze($type, $id)
    {
        // Simple SEO score calculation
        $score = 0;
        $suggestions = [];
        
        if ($type === 'post') {
            $item = Post::findOrFail($id);
            
            if ($item->meta_title) $score += 20;
            else $suggestions[] = 'Add a meta title';
            
            if ($item->meta_description) $score += 20;
            else $suggestions[] = 'Add a meta description';
            
            if ($item->featured_image) $score += 20;
            else $suggestions[] = 'Add a featured image';
            
            if (strlen($item->content) > 300) $score += 20;
            else $suggestions[] = 'Content should be at least 300 words';
            
            if ($item->category) $score += 20;
            else $suggestions[] = 'Add a category';
        }
        
        return response()->json([
            'score' => $score,
            'suggestions' => $suggestions
        ]);
    }
}
