<?php

namespace App\Http\Controllers;

use App\Models\Post;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function index(Request $request)
    {
        $query = Post::published()->latest('published_at');

        // Filter by category if provided
        if ($request->has('category') && $request->category) {
            $query->where('category', $request->category);
        }

        $posts = $query->paginate(12);
        $categories = Post::published()->distinct()->pluck('category')->filter();

        return view('blog.index', compact('posts', 'categories'));
    }

    public function show($slug)
    {
        $post = Post::where('slug', $slug)->published()->firstOrFail();
        $relatedPosts = $post->relatedPosts(3);

        return view('blog.show', compact('post', 'relatedPosts'));
    }
}
