<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Post extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'excerpt',
        'content',
        'featured_image',
        'category',
        'meta_title',
        'meta_description',
        'published_at',
        'affiliate_link',
        'cta_section',
    ];

    protected function casts(): array
    {
        return [
            'published_at' => 'datetime',
        ];
    }

    /**
     * Generate slug from title if not provided
     */
    public function setSlugAttribute($value)
    {
        if (empty($value) && isset($this->attributes['title'])) {
            $this->attributes['slug'] = Str::slug($this->attributes['title']);
        } elseif (!empty($value)) {
            $this->attributes['slug'] = Str::slug($value);
        }
    }

    /**
     * Get published posts
     */
    public function scopePublished($query)
    {
        return $query->whereNotNull('published_at')
                    ->where('published_at', '<=', now());
    }

    /**
     * Get related posts by category
     */
    public function relatedPosts($limit = 3)
    {
        return static::where('category', $this->category)
                    ->where('id', '!=', $this->id)
                    ->published()
                    ->limit($limit)
                    ->get();
    }
}
