<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = [
        'key',
        'value',
        'type', // string, json, boolean
    ];

    protected function casts(): array
    {
        return [
            'value' => 'array', // Will be handled based on type
        ];
    }

    /**
     * Get setting value by key.
     */
    public static function get($key, $default = null)
    {
        $setting = static::where('key', $key)->first();
        return $setting ? $setting->value : $default;
    }

    /**
     * Set setting value by key.
     */
    public static function set($key, $value)
    {
        return static::updateOrCreate(
            ['key' => $key],
            ['value' => $value, 'type' => gettype($value)]
        );
    }
}

