<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'name' => 'Admin',
                'slug' => 'admin',
                'description' => 'Full access to all admin features',
                'permissions' => ['*'], // All permissions
            ],
            [
                'name' => 'Editor',
                'slug' => 'editor',
                'description' => 'Can create, edit, and publish content',
                'permissions' => ['posts.create', 'posts.edit', 'posts.publish', 'products.create', 'products.edit'],
            ],
            [
                'name' => 'Writer',
                'slug' => 'writer',
                'description' => 'Can create and edit own content',
                'permissions' => ['posts.create', 'posts.edit'],
            ],
        ];

        foreach ($roles as $role) {
            Role::firstOrCreate(['slug' => $role['slug']], $role);
        }
    }
}
