@extends('layouts.main')

@section('title', 'About - Linkie.dev')

@section('content')
{{-- About Page: Mission and vision --}}
<section class="py-20 bg-[#121212]">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Page Header: Large title --}}
        <div class="text-center mb-16">
            <h1 class="text-5xl md:text-6xl font-black font-heading text-white mb-6">
                About <span class="text-[#00B4D8]">Linkie.dev</span>
            </h1>
        </div>

        {{-- Mission Section: Content with icons --}}
        <div class="mb-12">
            <div class="flex items-center mb-6">
                <div class="w-12 h-12 bg-[#00B4D8]/20 rounded-lg flex items-center justify-center mr-4">
                    <svg class="w-6 h-6 text-[#00B4D8]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                </div>
                <h2 class="text-3xl font-bold font-heading text-[#E0E0E0]">Our Mission</h2>
            </div>
            <p class="text-lg text-[#E0E0E0]/70 leading-relaxed">
                At Linkie.dev, we're dedicated to empowering developers and creators with high-quality technical content, 
                premium tools, and resources that help you build amazing things. We believe in sharing knowledge, 
                providing value, and fostering a community of passionate technologists.
            </p>
        </div>

        {{-- What We Do Section --}}
        <div class="mb-12">
            <div class="flex items-center mb-6">
                <div class="w-12 h-12 bg-[#00B4D8]/20 rounded-lg flex items-center justify-center mr-4">
                    <svg class="w-6 h-6 text-[#00B4D8]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                </div>
                <h2 class="text-3xl font-bold font-heading text-[#E0E0E0]">What We Do</h2>
            </div>
            <div class="space-y-4 text-lg text-[#E0E0E0]/70">
                <p>
                    <strong class="text-[#00B4D8]">Technical Blog:</strong> In-depth tutorials, reviews, and insights 
                    covering the latest technologies, frameworks, and best practices.
                </p>
                <p>
                    <strong class="text-[#00B4D8]">Product Showcase:</strong> Premium scripts, templates, and tools 
                    designed to accelerate your development workflow and bring your ideas to life faster.
                </p>
                <p>
                    <strong class="text-[#00B4D8]">Community:</strong> A platform where developers can learn, share, 
                    and grow together in the ever-evolving world of technology.
                </p>
            </div>
        </div>

        {{-- CTA Section: Contact link --}}
        <div class="text-center mt-16 pt-16 border-t border-gray-800">
            <h3 class="text-2xl font-bold font-heading text-[#E0E0E0] mb-4">Get in Touch</h3>
            <p class="text-[#E0E0E0]/70 mb-6">
                Have questions or want to collaborate? We'd love to hear from you!
            </p>
            <a href="{{ route('contact.index') }}" 
               class="inline-block px-8 py-4 bg-[#00B4D8] text-white font-bold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
                Contact Us
            </a>
        </div>
    </div>
</section>
@endsection

