@extends('admin.layouts.app')

@section('title', 'Edit Post - ' . $post->title)

@section('page-header')
<div class="flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Edit Post</h1>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Update post details</p>
    </div>
    <a href="{{ route('admin.content.posts.index') }}" 
       class="inline-flex items-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors">
        ← Back to Posts
    </a>
</div>
@endsection

@section('content')
<form action="{{ route('admin.content.posts.update', $post) }}" method="POST" enctype="multipart/form-data" class="space-y-6">
    @csrf
    @method('PUT')
    
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        {{-- Main Content Column --}}
        <div class="lg:col-span-2 space-y-6">
            {{-- Title --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Title <span class="text-red-500">*</span>
                </label>
                <input type="text" 
                       id="title" 
                       name="title" 
                       value="{{ old('title', $post->title) }}" 
                       required
                       class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                       placeholder="Enter post title">
                @error('title')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>
            
            {{-- Slug --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                <label for="slug" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Slug
                </label>
                <input type="text" 
                       id="slug" 
                       name="slug" 
                       value="{{ old('slug', $post->slug) }}"
                       class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                       placeholder="post-url-slug">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Leave empty to auto-generate from title</p>
                @error('slug')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>
            
            {{-- Content Editor --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 p-4 border-b border-gray-200 dark:border-gray-700">
                    Content <span class="text-red-500">*</span>
                </label>
                <x-admin.rich-editor name="content" value="{{ old('content', $post->content) }}" placeholder="Write your post content here..." />
                @error('content')
                    <p class="p-4 text-sm text-red-600 dark:text-red-400 border-t border-gray-200 dark:border-gray-700">{{ $message }}</p>
                @enderror
            </div>
            
            {{-- Excerpt --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                <label for="excerpt" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Excerpt
                </label>
                <textarea id="excerpt" 
                          name="excerpt" 
                          rows="3"
                          class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent resize-none"
                          placeholder="Brief description of the post">{{ old('excerpt', $post->excerpt) }}</textarea>
                @error('excerpt')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>
        </div>
        
        {{-- Sidebar Column --}}
        <div class="space-y-6">
            {{-- Publish Settings --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Publish</h3>
                <div class="space-y-4">
                    <div>
                        <label for="published_at" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Publish Date
                        </label>
                        <input type="datetime-local" 
                               id="published_at" 
                               name="published_at" 
                               value="{{ old('published_at', $post->published_at ? $post->published_at->format('Y-m-d\TH:i') : '') }}"
                               class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent">
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Leave empty to save as draft</p>
                    </div>
                    <div class="flex items-center justify-between pt-4 border-t border-gray-200 dark:border-gray-700">
                        <span class="text-sm text-gray-700 dark:text-gray-300">Status:</span>
                        <span class="px-3 py-1 text-xs font-semibold rounded-full {{ $post->published_at && $post->published_at <= now() ? 'bg-green-100 dark:bg-green-900/30 text-green-800 dark:text-green-400' : 'bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-300' }}" id="status-badge">
                            {{ $post->published_at && $post->published_at <= now() ? 'Published' : 'Draft' }}
                        </span>
                    </div>
                </div>
            </div>
            
            {{-- Featured Image --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Featured Image</h3>
                @if($post->featured_image)
                    <div class="mb-4">
                        <img src="{{ Storage::url($post->featured_image) }}" 
                             alt="Current featured image" 
                             class="w-full h-48 object-cover rounded-lg mb-2">
                        <p class="text-xs text-gray-500 dark:text-gray-400">Current image</p>
                    </div>
                @endif
                <input type="file" 
                       id="featured_image" 
                       name="featured_image" 
                       accept="image/*"
                       class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Upload a new image to replace the current one</p>
                <div id="image-preview" class="mt-4 hidden">
                    <img id="preview-img" src="" alt="Preview" class="w-full h-48 object-cover rounded-lg">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">New image preview</p>
                </div>
                @error('featured_image')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>
            
            {{-- Category --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                <label for="category" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Category
                </label>
                <input type="text" 
                       id="category" 
                       name="category" 
                       value="{{ old('category', $post->category) }}"
                       class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                       placeholder="e.g., Tutorial, Review">
                @error('category')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>
            
            {{-- Affiliate & CTA Settings --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Affiliate & CTA</h3>
                <div class="space-y-4">
                    <div>
                        <label for="affiliate_link" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Affiliate Link
                        </label>
                        <input type="url" 
                               id="affiliate_link" 
                               name="affiliate_link" 
                               value="{{ old('affiliate_link', $post->affiliate_link) }}"
                               class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                               placeholder="https://example.com/affiliate">
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">This link will be used in CTA blocks throughout the article</p>
                    </div>
                    <div>
                        <label for="cta_section" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            CTA Text
                        </label>
                        <input type="text" 
                               id="cta_section" 
                               name="cta_section" 
                               value="{{ old('cta_section', $post->cta_section) }}"
                               class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                               placeholder="e.g., Ready to get started?">
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Optional custom text for CTA blocks</p>
                    </div>
                </div>
            </div>
            
            {{-- SEO Settings --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">SEO Settings</h3>
                <div class="space-y-4">
                    <div>
                        <label for="meta_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Meta Title
                        </label>
                        <input type="text" 
                               id="meta_title" 
                               name="meta_title" 
                               value="{{ old('meta_title', $post->meta_title) }}"
                               class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                               placeholder="SEO title (optional)">
                    </div>
                    <div>
                        <label for="meta_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Meta Description
                        </label>
                        <textarea id="meta_description" 
                                  name="meta_description" 
                                  rows="3"
                                  class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent resize-none"
                                  placeholder="SEO description (optional)">{{ old('meta_description', $post->meta_description) }}</textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    {{-- Action Buttons --}}
    <div class="flex items-center justify-between pt-6 border-t border-gray-200 dark:border-gray-700">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.content.posts.index') }}" 
               class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors">
                Cancel
            </a>
            <a href="{{ route('admin.content.posts.show', $post) }}" 
               class="px-6 py-2 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 font-medium rounded-lg transition-colors">
                View Post
            </a>
        </div>
        <button type="submit" 
                class="px-6 py-2 bg-cyan-600 hover:bg-cyan-700 text-white font-medium rounded-lg transition-colors">
            Update Post
        </button>
    </div>
</form>

@push('scripts')
<script>
    // Image preview
    document.getElementById('featured_image')?.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('preview-img').src = e.target.result;
                document.getElementById('image-preview').classList.remove('hidden');
            };
            reader.readAsDataURL(file);
        } else {
            document.getElementById('image-preview').classList.add('hidden');
        }
    });
    
    // Status badge update
    document.getElementById('published_at')?.addEventListener('change', function(e) {
        const badge = document.getElementById('status-badge');
        if (e.target.value) {
            const selectedDate = new Date(e.target.value);
            const now = new Date();
            if (selectedDate <= now) {
                badge.textContent = 'Published';
                badge.className = 'px-3 py-1 text-xs font-semibold rounded-full bg-green-100 dark:bg-green-900/30 text-green-800 dark:text-green-400';
            } else {
                badge.textContent = 'Scheduled';
                badge.className = 'px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 dark:bg-blue-900/30 text-blue-800 dark:text-blue-400';
            }
        } else {
            badge.textContent = 'Draft';
            badge.className = 'px-3 py-1 text-xs font-semibold rounded-full bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-300';
        }
    });
</script>
@endpush
@endsection

