@extends('layouts.admin')

@section('title', 'Admin Dashboard - Linkie.dev')

@section('content')
{{-- Dashboard: Statistics and overview --}}
<div>
    <h1 class="text-4xl font-bold font-heading text-white mb-8">Dashboard</h1>

    {{-- Stats Grid: 3 columns, responsive --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        {{-- Posts Count Card --}}
        <div class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-[#E0E0E0]/70 text-sm mb-2">Total Posts</p>
                    <p class="text-3xl font-bold text-[#00B4D8]">{{ $postsCount }}</p>
                </div>
                <div class="w-12 h-12 bg-[#00B4D8]/20 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-[#00B4D8]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                </div>
            </div>
        </div>

        {{-- Products Count Card --}}
        <div class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-[#E0E0E0]/70 text-sm mb-2">Total Products</p>
                    <p class="text-3xl font-bold text-[#00B4D8]">{{ $productsCount }}</p>
                </div>
                <div class="w-12 h-12 bg-[#00B4D8]/20 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-[#00B4D8]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                    </svg>
                </div>
            </div>
        </div>

        {{-- Contacts Count Card --}}
        <div class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-[#E0E0E0]/70 text-sm mb-2">Contact Messages</p>
                    <p class="text-3xl font-bold text-[#00B4D8]">{{ $contactsCount }}</p>
                </div>
                <div class="w-12 h-12 bg-[#00B4D8]/20 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-[#00B4D8]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                    </svg>
                </div>
            </div>
        </div>
    </div>

    {{-- Quick Actions: Buttons to create new content --}}
    <div class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-6">
        <h2 class="text-2xl font-bold font-heading text-white mb-4">Quick Actions</h2>
        <div class="flex flex-wrap gap-4">
            <a href="{{ route('admin.content.posts.create') }}" 
               class="px-6 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
                Create New Post
            </a>
            <a href="{{ route('admin.products.create') }}" 
               class="px-6 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
                Create New Product
            </a>
        </div>
    </div>
</div>
@endsection

