<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{ darkMode: localStorage.getItem('darkMode') === 'true' || true }" :class="{ 'dark': darkMode }">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {{-- Prevent Flash of Unstyled Content (FOUC) - Apply dark mode immediately --}}
    <script>
        (function() {
            // Check localStorage for dark mode preference (default to dark)
            const darkMode = localStorage.getItem('darkMode') !== 'false';
            
            // Apply dark class immediately before page renders
            if (darkMode) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        })();
    </script>

    <title>@yield('title', 'Admin Dashboard') - {{ config('app.name', 'Linkie.dev') }}</title>

    <!-- Google Fonts - Inter & Poppins for modern typography -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    {{-- Inline CSS to prevent white flash - set default dark background --}}
    <style>
        /* Prevent white flash - default to dark mode */
        html {
            color-scheme: dark;
        }
        /* Default dark background - will be overridden by Tailwind when it loads */
        body {
            background-color: #111827 !important; /* gray-900 */
            color: #F3F4F6 !important; /* gray-100 */
            margin: 0;
            padding: 0;
        }
        /* When light mode is explicitly set */
        html:not(.dark) body {
            background-color: #F9FAFB !important; /* gray-50 */
            color: #111827 !important; /* gray-900 */
        }
        /* Ensure dark mode body stays dark */
        html.dark body {
            background-color: #111827 !important;
            color: #F3F4F6 !important;
        }
    </style>
    
    <!-- Alpine.js for reactive UI -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    @stack('styles')
</head>
<body class="font-sans antialiased bg-gray-50 dark:bg-gray-900 text-gray-900 dark:text-gray-100 transition-colors duration-200" 
      x-bind:class="darkMode ? 'dark' : ''">
    
    <div class="min-h-screen flex" x-data="{ sidebarOpen: window.innerWidth >= 1024 }">
        <!-- Sidebar -->
        @include('admin.components.sidebar')
        
        <!-- Main Content Area -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Header -->
            @include('admin.components.header')
            
            <!-- Page Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 dark:bg-gray-900 p-6 lg:p-8">
                <!-- Flash Messages -->
                @include('admin.components.flash-messages')
                
                <!-- Page Header -->
                @hasSection('page-header')
                    <div class="mb-6">
                        @yield('page-header')
                    </div>
                @endif
                
                <!-- Main Content -->
                @yield('content')
            </main>
        </div>
    </div>
    
    <!-- Modals -->
    @stack('modals')
    
    <!-- Scripts -->
    @stack('scripts')
    
    <script>
        // Theme persistence and sync
        document.addEventListener('alpine:init', () => {
            const isDark = localStorage.getItem('darkMode') !== 'false';
            
            Alpine.store('theme', {
                dark: isDark,
                toggle() {
                    this.dark = !this.dark;
                    localStorage.setItem('darkMode', this.dark);
                    // Immediately update HTML class
                    document.documentElement.classList.toggle('dark', this.dark);
                }
            });
            
            // Ensure HTML class is synced on init
            document.documentElement.classList.toggle('dark', isDark);
        });
    </script>
</body>
</html>

