@extends('layouts.admin')

@section('title', 'Create Post - Admin')

@section('content')
{{-- Page Header: Title and back link --}}
<div class="mb-8">
    {{-- Page Title: Large text (4xl), bold, heading font, white text --}}
    <h1 class="text-4xl font-bold font-heading text-white">Create New Post</h1>
    {{-- Back Link: Accent color, hover effect, top margin, inline-block --}}
    <a href="{{ route('admin.content.posts.index') }}" class="text-[#00B4D8] hover:text-[#00B4D8]/80 mt-2 inline-block">
        ← Back to Posts
    </a>
</div>

{{-- Create Post Form: Dark card background, border, rounded corners, padding --}}
<form action="{{ route('admin.content.posts.store') }}" method="POST" enctype="multipart/form-data" class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-8">
    @csrf

    {{-- Form Fields Container: Vertical spacing between fields (space-y-6) --}}
    <div class="space-y-6">
        {{-- Title Field: Required input with validation --}}
        <div>
            {{-- Label: Block display, light text, semibold, bottom margin --}}
            <label for="title" class="block text-[#E0E0E0] font-semibold mb-2">Title *</label>
            {{-- Input: Full width, padding, dark background, border, rounded, light text, focus accent border --}}
            <input type="text" id="title" name="title" value="{{ old('title') }}" required
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            {{-- Error Message: Top margin, small text, red color --}}
            @error('title')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Slug --}}
        <div>
            <label for="slug" class="block text-[#E0E0E0] font-semibold mb-2">Slug (auto-generated if empty)</label>
            <input type="text" id="slug" name="slug" value="{{ old('slug') }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('slug')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Category --}}
        <div>
            <label for="category" class="block text-[#E0E0E0] font-semibold mb-2">Category</label>
            <input type="text" id="category" name="category" value="{{ old('category') }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('category')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Excerpt --}}
        <div>
            <label for="excerpt" class="block text-[#E0E0E0] font-semibold mb-2">Excerpt</label>
            <textarea id="excerpt" name="excerpt" rows="3"
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none">{{ old('excerpt') }}</textarea>
            @error('excerpt')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Content --}}
        <div>
            <label for="content" class="block text-[#E0E0E0] font-semibold mb-2">Content *</label>
            <textarea id="content" name="content" rows="12" required
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none">{{ old('content') }}</textarea>
            @error('content')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Featured Image --}}
        <div>
            <label for="featured_image" class="block text-[#E0E0E0] font-semibold mb-2">Featured Image</label>
            <input type="file" id="featured_image" name="featured_image" accept="image/*"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('featured_image')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Meta Title --}}
        <div>
            <label for="meta_title" class="block text-[#E0E0E0] font-semibold mb-2">SEO Meta Title</label>
            <input type="text" id="meta_title" name="meta_title" value="{{ old('meta_title') }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('meta_title')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Meta Description --}}
        <div>
            <label for="meta_description" class="block text-[#E0E0E0] font-semibold mb-2">SEO Meta Description</label>
            <textarea id="meta_description" name="meta_description" rows="3"
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none">{{ old('meta_description') }}</textarea>
            @error('meta_description')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Published At --}}
        <div>
            <label for="published_at" class="block text-[#E0E0E0] font-semibold mb-2">Publish Date (leave empty for draft)</label>
            <input type="datetime-local" id="published_at" name="published_at" value="{{ old('published_at') }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('published_at')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Submit Button --}}
        <div class="flex space-x-4">
            <button type="submit" 
                    class="px-8 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
                Create Post
            </button>
            <a href="{{ route('admin.content.posts.index') }}" 
               class="px-8 py-3 bg-gray-700 text-[#E0E0E0] font-semibold rounded-lg hover:bg-gray-600 transition-colors">
                Cancel
            </a>
        </div>
    </div>
</form>
@endsection

