@extends('layouts.admin')

@section('title', 'Edit Post - Admin')

@section('content')
<div class="mb-8">
    <h1 class="text-4xl font-bold font-heading text-white">Edit Post</h1>
    <a href="{{ route('admin.content.posts.index') }}" class="text-[#00B4D8] hover:text-[#00B4D8]/80 mt-2 inline-block">
        ← Back to Posts
    </a>
</div>

<form action="{{ route('admin.content.posts.update', $post) }}" method="POST" enctype="multipart/form-data" class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-8">
    @csrf
    @method('PUT')

    <div class="space-y-6">
        {{-- Title --}}
        <div>
            <label for="title" class="block text-[#E0E0E0] font-semibold mb-2">Title *</label>
            <input type="text" id="title" name="title" value="{{ old('title', $post->title) }}" required
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('title')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Slug --}}
        <div>
            <label for="slug" class="block text-[#E0E0E0] font-semibold mb-2">Slug</label>
            <input type="text" id="slug" name="slug" value="{{ old('slug', $post->slug) }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('slug')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Category --}}
        <div>
            <label for="category" class="block text-[#E0E0E0] font-semibold mb-2">Category</label>
            <input type="text" id="category" name="category" value="{{ old('category', $post->category) }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('category')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Excerpt --}}
        <div>
            <label for="excerpt" class="block text-[#E0E0E0] font-semibold mb-2">Excerpt</label>
            <textarea id="excerpt" name="excerpt" rows="3"
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none">{{ old('excerpt', $post->excerpt) }}</textarea>
            @error('excerpt')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Content --}}
        <div>
            <label for="content" class="block text-[#E0E0E0] font-semibold mb-2">Content *</label>
            <textarea id="content" name="content" rows="12" required
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none">{{ old('content', $post->content) }}</textarea>
            @error('content')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Featured Image --}}
        <div>
            <label for="featured_image" class="block text-[#E0E0E0] font-semibold mb-2">Featured Image</label>
            @if($post->featured_image)
                <div class="mb-4">
                    <img src="{{ Storage::url($post->featured_image) }}" alt="Current image" class="w-32 h-32 object-cover rounded-lg">
                </div>
            @endif
            <input type="file" id="featured_image" name="featured_image" accept="image/*"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('featured_image')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Meta Title --}}
        <div>
            <label for="meta_title" class="block text-[#E0E0E0] font-semibold mb-2">SEO Meta Title</label>
            <input type="text" id="meta_title" name="meta_title" value="{{ old('meta_title', $post->meta_title) }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('meta_title')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Meta Description --}}
        <div>
            <label for="meta_description" class="block text-[#E0E0E0] font-semibold mb-2">SEO Meta Description</label>
            <textarea id="meta_description" name="meta_description" rows="3"
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none">{{ old('meta_description', $post->meta_description) }}</textarea>
            @error('meta_description')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Published At --}}
        <div>
            <label for="published_at" class="block text-[#E0E0E0] font-semibold mb-2">Publish Date</label>
            <input type="datetime-local" id="published_at" name="published_at" 
                   value="{{ old('published_at', $post->published_at?->format('Y-m-d\TH:i')) }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('published_at')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        {{-- Submit Button --}}
        <div class="flex space-x-4">
            <button type="submit" 
                    class="px-8 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
                Update Post
            </button>
            <a href="{{ route('admin.content.posts.index') }}" 
               class="px-8 py-3 bg-gray-700 text-[#E0E0E0] font-semibold rounded-lg hover:bg-gray-600 transition-colors">
                Cancel
            </a>
        </div>
    </div>
</form>
@endsection

