@extends('admin.layouts.app')

@section('title', 'Roles Management')

@section('page-header')
<div class="flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Roles</h1>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Manage user roles and permissions</p>
    </div>
    <a href="{{ route('admin.users.roles.create') }}" 
       class="inline-flex items-center px-4 py-2 bg-cyan-600 hover:bg-cyan-700 text-white font-medium rounded-lg transition-colors">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
        </svg>
        New Role
    </a>
</div>
@endsection

@section('content')
<div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
    <p class="text-gray-500 dark:text-gray-400 text-center py-12">
        Role management interface coming soon. Roles are currently managed via database seeders.
    </p>
</div>
@endsection


