@extends('admin.layouts.app')

@section('title', 'User Details')

@section('page-header')
<div class="flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">User Details</h1>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">View user information and roles</p>
    </div>
    <a href="{{ route('admin.users.users.index') }}" 
       class="inline-flex items-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors">
        ← Back to Users
    </a>
</div>
@endsection

@section('content')
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">User Information</h2>
        <dl class="space-y-4">
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Name</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $user->name }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Email</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $user->email }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Created</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $user->created_at->format('F d, Y \a\t g:i A') }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Last Updated</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $user->updated_at->format('F d, Y \a\t g:i A') }}</dd>
            </div>
        </dl>
    </div>
    
    <div class="space-y-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Roles</h3>
            <div class="space-y-2">
                @forelse($user->roles as $role)
                    <span class="inline-block px-3 py-1 text-sm font-semibold rounded-full bg-cyan-100 dark:bg-cyan-900/30 text-cyan-800 dark:text-cyan-400">
                        {{ $role->name }}
                    </span>
                @empty
                    <p class="text-sm text-gray-500 dark:text-gray-400">No roles assigned</p>
                @endforelse
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Actions</h3>
            <div class="space-y-3">
                <a href="{{ route('admin.users.users.edit', $user) }}" 
                   class="block w-full px-4 py-2 bg-cyan-600 hover:bg-cyan-700 text-white text-center font-medium rounded-lg transition-colors">
                    Edit User
                </a>
                <form action="{{ route('admin.users.users.destroy', $user) }}" 
                      method="POST" 
                      onsubmit="return confirm('Delete this user?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" 
                            class="block w-full px-4 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors">
                        Delete User
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection


