{{-- Blog Post Card Component - Reusable dark card with hover effect and accent color transitions --}}
{{-- Link wrapper: Block display, group class for hover effects on child elements --}}
<a href="{{ route('blog.show', $post->slug) }}" class="block group">
    {{-- Card Container: Dark card background (#1a1a1a), rounded corners, overflow hidden, border with hover accent color, smooth transitions, shadow on hover --}}
    <div class="bg-[#1a1a1a] rounded-lg overflow-hidden border border-gray-800 hover:border-[#00B4D8] transition-all duration-300 hover:shadow-lg hover:shadow-[#00B4D8]/20">
        {{-- Featured Image Section: Conditional rendering if post has featured image --}}
        @if($post->featured_image)
            {{-- Image Container: 16:9 aspect ratio, full width, overflow hidden, dark background fallback --}}
            <div class="aspect-video w-full overflow-hidden bg-gray-900">
                {{-- Post Image: Full width/height, object-cover for proper scaling, scale on hover (group-hover), smooth transition --}}
                <img src="{{ Storage::url($post->featured_image) }}" 
                     alt="{{ $post->title }}"
                     class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
            </div>
        @else
            {{-- Placeholder: Gradient background from dark blue to accent cyan, centered content with emoji --}}
            <div class="aspect-video w-full bg-gradient-to-br from-[#1E3A8A] to-[#00B4D8] flex items-center justify-center">
                <span class="text-4xl font-bold text-white/50">📝</span>
            </div>
        @endif

        {{-- Card Content Section: Padding (p-6 = 1.5rem) for spacing --}}
        <div class="p-6">
            {{-- Category Badge: Conditional rendering, inline-block, small padding, accent color text and background, rounded-full, bottom margin --}}
            @if($post->category)
                <span class="inline-block px-3 py-1 text-xs font-semibold text-[#00B4D8] bg-[#00B4D8]/10 rounded-full mb-3">
                    {{ $post->category }}
                </span>
            @endif

            {{-- Post Title: Large text (xl), bold weight, heading font, light text color, hover accent color, bottom margin, line clamp to 2 lines --}}
            <h3 class="text-xl font-bold font-heading text-[#E0E0E0] group-hover:text-[#00B4D8] transition-colors mb-2 line-clamp-2">
                {{ $post->title }}
            </h3>

            {{-- Excerpt: Conditional rendering, muted text (70% opacity), small text, bottom margin, line clamp to 3 lines --}}
            @if($post->excerpt)
                <p class="text-[#E0E0E0]/70 text-sm mb-4 line-clamp-3">
                    {{ $post->excerpt }}
                </p>
            @endif

            {{-- Meta Info Section: Flex layout, centered items, extra small text, dimmed text color (50% opacity) --}}
            <div class="flex items-center text-xs text-[#E0E0E0]/50">
                {{-- Calendar Icon: Small size (w-4 h-4), right margin --}}
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                </svg>
                {{-- Publication Date: Formatted date, fallback to creation date if not published --}}
                <span>{{ $post->published_at?->format('M d, Y') ?? $post->created_at->format('M d, Y') }}</span>
            </div>
        </div>
    </div>
</a>

