{{-- FAQ Accordion Component: Collapsible FAQ items using Alpine.js --}}
@props(['faqs' => []])

@if(!empty($faqs))
    <div class="my-10 space-y-4" x-data="{ openIndex: null }">
        {{-- FAQ Section Title: Large heading, cyan accent, bottom margin --}}
        <h2 class="text-3xl font-bold font-heading text-white mb-6">Frequently Asked Questions</h2>
        
        {{-- FAQ Items: Loop through FAQs, each with toggle functionality --}}
        @foreach($faqs as $index => $faq)
            @php
                $question = is_array($faq) ? ($faq['question'] ?? $faq['q'] ?? '') : '';
                $answer = is_array($faq) ? ($faq['answer'] ?? $faq['a'] ?? '') : $faq;
            @endphp
            
            @if(!empty($question) && !empty($answer))
                {{-- FAQ Item: Card with border, rounded corners, hover effect --}}
                <div class="bg-[#1A1A1A] border border-gray-800 rounded-xl overflow-hidden transition-all hover:border-cyan-500/30">
                    {{-- Question Button: Clickable header with icon, flex layout --}}
                    <button 
                        @click="openIndex = openIndex === {{ $index }} ? null : {{ $index }}"
                        class="w-full px-6 py-4 text-left flex items-center justify-between focus:outline-none focus:ring-2 focus:ring-cyan-500/50 rounded-t-xl"
                        :class="openIndex === {{ $index }} ? 'bg-[#1D1D1D]' : 'bg-[#1A1A1A]'">
                        {{-- Question Text: Bold, white text, responsive size --}}
                        <span class="text-lg font-semibold text-white pr-4">{{ $question }}</span>
                        {{-- Toggle Icon: Chevron that rotates when open --}}
                        <svg 
                            class="w-5 h-5 text-cyan-400 flex-shrink-0 transition-transform duration-200"
                            :class="openIndex === {{ $index }} ? 'rotate-180' : ''"
                            fill="none" 
                            stroke="currentColor" 
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    
                    {{-- Answer Content: Collapsible content area with smooth transition --}}
                    <div 
                        x-show="openIndex === {{ $index }}"
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-2"
                        class="px-6 py-4 border-t border-gray-800"
                        style="display: none;">
                        <p class="text-[#E0E0E0] leading-relaxed">{{ $answer }}</p>
                    </div>
                </div>
            @endif
        @endforeach
    </div>
@endif

