@extends('layouts.main')

@section('title', 'Linkie.dev - Technical Blog & Product Showcase')

@section('content')
{{-- Hero Section: Full width, centered content, bold typography --}}
<section class="relative bg-gradient-to-br from-[#1E3A8A] via-[#121212] to-[#121212] py-20 lg:py-32">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            {{-- Main Title: Extra large, bold, accent color --}}
            <h1 class="text-5xl md:text-7xl font-black font-heading text-white mb-6 leading-tight">
                Welcome to <span class="text-[#00B4D8]">Linkie.dev</span>
            </h1>
            
            {{-- Subtitle: Medium size, lighter weight, centered --}}
            <p class="text-xl md:text-2xl text-[#E0E0E0]/80 mb-8 max-w-3xl mx-auto">
                Your destination for technical tutorials, product reviews, and premium tools. Learn, explore, and build amazing things.
            </p>

            {{-- CTA Buttons: Flex layout, responsive spacing --}}
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                {{-- Primary CTA: Accent background, white text --}}
                <a href="{{ route('blog.index') }}" 
                   class="px-8 py-4 bg-[#00B4D8] text-white font-bold rounded-lg hover:bg-[#00B4D8]/80 transition-colors shadow-lg shadow-[#00B4D8]/30">
                    Start Learning
                </a>
                
                {{-- Secondary CTA: Outlined, accent border --}}
                <a href="{{ route('products.index') }}" 
                   class="px-8 py-4 border-2 border-[#00B4D8] text-[#00B4D8] font-bold rounded-lg hover:bg-[#00B4D8]/10 transition-colors">
                    Explore Tools
                </a>
            </div>
        </div>
    </div>
</section>

{{-- Latest Blog Posts Section: Dark background, grid layout --}}
<section class="py-16 bg-[#121212]">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header: Title and view all link --}}
        <div class="flex justify-between items-center mb-12">
            <h2 class="text-4xl font-bold font-heading text-[#E0E0E0]">Latest Blog Posts</h2>
            <a href="{{ route('blog.index') }}" class="text-[#00B4D8] hover:text-[#00B4D8]/80 font-semibold transition-colors">
                View All →
            </a>
        </div>

        {{-- Posts Grid: Responsive grid, 3 columns on desktop, 1 on mobile --}}
        @if($latestPosts->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @foreach($latestPosts as $post)
                    <x-blog-card :post="$post" />
                @endforeach
            </div>
        @else
            {{-- Empty State: Centered message --}}
            <div class="text-center py-12">
                <p class="text-[#E0E0E0]/50 text-lg">No blog posts yet. Check back soon!</p>
            </div>
        @endif
    </div>
</section>

{{-- Featured Products Section: Dark background, grid layout --}}
<section class="py-16 bg-[#0a0a0a]">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header: Title and view all link --}}
        <div class="flex justify-between items-center mb-12">
            <h2 class="text-4xl font-bold font-heading text-[#E0E0E0]">Featured Products</h2>
            <a href="{{ route('products.index') }}" class="text-[#00B4D8] hover:text-[#00B4D8]/80 font-semibold transition-colors">
                View All →
            </a>
        </div>

        {{-- Products Grid: Responsive grid, 3 columns on desktop, 1 on mobile --}}
        @if($featuredProducts->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @foreach($featuredProducts as $product)
                    <x-product-card :product="$product" />
                @endforeach
            </div>
        @else
            {{-- Empty State: Centered message --}}
            <div class="text-center py-12">
                <p class="text-[#E0E0E0]/50 text-lg">No products yet. Check back soon!</p>
            </div>
        @endif
    </div>
</section>

{{-- About Snippet Section: Brief intro, CTA to full about page --}}
<section class="py-16 bg-[#121212]">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl font-bold font-heading text-[#E0E0E0] mb-6">About Linkie.dev</h2>
        <p class="text-lg text-[#E0E0E0]/70 mb-8 max-w-2xl mx-auto">
            We're passionate about technology and helping developers build amazing things. 
            From in-depth tutorials to premium tools and templates, we've got you covered.
        </p>
        <a href="{{ route('about.index') }}" 
           class="inline-block px-6 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
            Learn More
        </a>
    </div>
</section>
@endsection

