<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Linkie.dev - Technical Blog & Product Showcase')</title>

    <!-- SEO Meta Tags -->
    @yield('meta')

    <!-- Google Fonts - Inter, Montserrat, Cairo for bold typography -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Montserrat:wght@700;800;900&family=Cairo:wght@400;700;900&display=swap" rel="stylesheet">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Alpine.js for interactive components (FAQ accordion, etc.) -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-[#121212] text-[#E0E0E0] font-sans antialiased">
    <!-- Navigation Component -->
    @include('components.navbar')

    <!-- Main Content -->
    <main>
        @yield('content')
    </main>

    <!-- Footer Component -->
    @include('components.footer')

    <!-- Flash Messages: Fixed position notification with auto-dismiss --}}
    @if(session('success'))
        {{-- Success Message: Fixed bottom-right, accent background, white text, padding, rounded, shadow, high z-index --}}
        <div class="fixed bottom-4 right-4 bg-[#00B4D8] text-white px-6 py-3 rounded-lg shadow-lg z-50 animate-fade-in">
            {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        {{-- Error Message: Fixed bottom-right, red background, white text, padding, rounded, shadow, high z-index --}}
        <div class="fixed bottom-4 right-4 bg-red-600 text-white px-6 py-3 rounded-lg shadow-lg z-50 animate-fade-in">
            {{ session('error') }}
        </div>
    @endif
</body>
</html>

