@extends('layouts.main')

@section('title', 'Products - Linkie.dev')

@section('content')
{{-- Products List Page: Dark background section with responsive grid layout --}}
<section class="py-12 bg-[#121212]">
    {{-- Container: max-width 7xl (1280px), centered, responsive horizontal padding --}}
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Page Header: Centered title and description section --}}
        <div class="text-center mb-12">
            {{-- Main Title: Extra large (5xl), black weight, heading font, white text, bottom margin --}}
            <h1 class="text-5xl font-black font-heading text-white mb-4">
                Our <span class="text-[#00B4D8]">Products</span>
            </h1>
            {{-- Description: Large text (xl), muted text color (70% opacity), max-width constraint, centered --}}
            <p class="text-xl text-[#E0E0E0]/70 max-w-2xl mx-auto">
                Premium scripts, templates, and tools to accelerate your development
            </p>
        </div>

        {{-- Products Grid: Conditional rendering based on product count --}}
        @if($products->count() > 0)
            {{-- Responsive Grid: 1 column on mobile, 2 on tablet (md), 3 on desktop (lg), gap spacing --}}
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
                @foreach($products as $product)
                    {{-- Product Card Component: Reusable card with hover effects --}}
                    <x-product-card :product="$product" />
                @endforeach
            </div>

            {{-- Pagination: Flexbox centered alignment for pagination links --}}
            <div class="flex justify-center">
                {{ $products->links() }}
            </div>
        @else
            {{-- Empty State: Centered message when no products available --}}
            <div class="text-center py-16">
                {{-- Empty Message: Large text (xl), dimmed text color (50% opacity) --}}
                <p class="text-[#E0E0E0]/50 text-xl">No products available yet. Check back soon!</p>
            </div>
        @endif
    </div>
</section>
@endsection

