

<a href="<?php echo e(route('blog.show', $post->slug)); ?>" class="block group">
    
    <div class="bg-[#1a1a1a] rounded-lg overflow-hidden border border-gray-800 hover:border-[#00B4D8] transition-all duration-300 hover:shadow-lg hover:shadow-[#00B4D8]/20">
        
        <?php if($post->featured_image): ?>
            
            <div class="aspect-video w-full overflow-hidden bg-gray-900">
                
                <img src="<?php echo e(Storage::url($post->featured_image)); ?>" 
                     alt="<?php echo e($post->title); ?>"
                     class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
            </div>
        <?php else: ?>
            
            <div class="aspect-video w-full bg-gradient-to-br from-[#1E3A8A] to-[#00B4D8] flex items-center justify-center">
                <span class="text-4xl font-bold text-white/50">📝</span>
            </div>
        <?php endif; ?>

        
        <div class="p-6">
            
            <?php if($post->category): ?>
                <span class="inline-block px-3 py-1 text-xs font-semibold text-[#00B4D8] bg-[#00B4D8]/10 rounded-full mb-3">
                    <?php echo e($post->category); ?>

                </span>
            <?php endif; ?>

            
            <h3 class="text-xl font-bold font-heading text-[#E0E0E0] group-hover:text-[#00B4D8] transition-colors mb-2 line-clamp-2">
                <?php echo e($post->title); ?>

            </h3>

            
            <?php if($post->excerpt): ?>
                <p class="text-[#E0E0E0]/70 text-sm mb-4 line-clamp-3">
                    <?php echo e($post->excerpt); ?>

                </p>
            <?php endif; ?>

            
            <div class="flex items-center text-xs text-[#E0E0E0]/50">
                
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                </svg>
                
                <span><?php echo e($post->published_at?->format('M d, Y') ?? $post->created_at->format('M d, Y')); ?></span>
            </div>
        </div>
    </div>
</a>

<?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/components/blog-card.blade.php ENDPATH**/ ?>