<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Admin - Linkie.dev'); ?></title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Montserrat:wght@700;800;900&family=Cairo:wght@400;700;900&display=swap" rel="stylesheet">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-[#121212] text-[#E0E0E0] font-sans antialiased">
    <div class="min-h-screen flex">
        
        <aside class="w-64 bg-[#1a1a1a] border-r border-gray-800 min-h-screen">
            <div class="p-6">
                <h2 class="text-2xl font-bold font-heading text-[#00B4D8] mb-8">Linkie.dev Admin</h2>
                
                <nav class="space-y-2">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" 
                       class="block px-4 py-2 rounded-lg <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-[#00B4D8] text-white' : 'text-[#E0E0E0]/70 hover:bg-gray-800'); ?> transition-colors">
                        Dashboard
                    </a>
                    <a href="<?php echo e(route('admin.content.posts.index')); ?>" 
                       class="block px-4 py-2 rounded-lg <?php echo e(request()->routeIs('admin.content.posts.*') ? 'bg-[#00B4D8] text-white' : 'text-[#E0E0E0]/70 hover:bg-gray-800'); ?> transition-colors">
                        Posts
                    </a>
                    <a href="<?php echo e(route('admin.products.index')); ?>" 
                       class="block px-4 py-2 rounded-lg <?php echo e(request()->routeIs('admin.products.*') ? 'bg-[#00B4D8] text-white' : 'text-[#E0E0E0]/70 hover:bg-gray-800'); ?> transition-colors">
                        Products
                    </a>
                    <a href="<?php echo e(route('home')); ?>" 
                       class="block px-4 py-2 rounded-lg text-[#E0E0E0]/70 hover:bg-gray-800 transition-colors">
                        View Site
                    </a>
                    <form method="POST" action="<?php echo e(route('logout')); ?>" class="pt-4">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="block w-full text-left px-4 py-2 rounded-lg text-[#E0E0E0]/70 hover:bg-gray-800 transition-colors">
                            Logout
                        </button>
                    </form>
                </nav>
            </div>
        </aside>

        
        <main class="flex-1 p-8">
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-500/20 border border-green-500 text-green-400 px-4 py-3 rounded-lg">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/layouts/admin.blade.php ENDPATH**/ ?>