
<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['post']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['post']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    // Get affiliate link from database first, then extract from content as fallback
    $affiliateLink = $post->affiliate_link ?? '';
    $content = html_entity_decode($post->content, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    
    // If not in database, try to extract from content
    if (empty($affiliateLink)) {
        if (preg_match('/href=["\']([^"\']+)["\'].*target=["\']_blank["\']/', $content, $matches)) {
            $affiliateLink = $matches[1];
        }
    }
    
    // Extract pros/features for key benefits
    $pros = [];
    if (preg_match('/<h2>Pros<\/h2><ul>(.*?)<\/ul>/s', $content, $matches)) {
        preg_match_all('/<li>(.*?)<\/li>/', $matches[1], $proMatches);
        $pros = array_slice(array_map('strip_tags', $proMatches[1]), 0, 3); // Take first 3
    }
    
    // If no pros, try features
    if (empty($pros) && preg_match('/<h2>Features<\/h2><ul>(.*?)<\/ul>/s', $content, $matches)) {
        preg_match_all('/<li>(.*?)<\/li>/', $matches[1], $featureMatches);
        $pros = array_slice(array_map('strip_tags', $featureMatches[1]), 0, 3);
    }
    
    // Get featured image
    $imageUrl = $post->featured_image ? Storage::url($post->featured_image) : null;
?>

<?php if($affiliateLink || $imageUrl || !empty($pros)): ?>
    
    <div class="sticky top-24 space-y-4 bg-[#1A1A1A] p-6 rounded-xl border border-gray-800 shadow-xl">
        
        <?php if($imageUrl): ?>
            <div class="mb-4">
                <img 
                    src="<?php echo e($imageUrl); ?>" 
                    alt="<?php echo e($post->title); ?>"
                    class="w-full h-auto rounded-lg object-cover">
            </div>
        <?php endif; ?>
        
        
        <h3 class="text-xl font-bold text-white line-clamp-2"><?php echo e($post->title); ?></h3>
        
        
        <?php if (isset($component)) { $__componentOriginal077a61d60611f096a94f8e1725d6bb16 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal077a61d60611f096a94f8e1725d6bb16 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.rating-stars','data' => ['rating' => 4.8,'reviewCount' => 2100,'size' => 'sm']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('rating-stars'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['rating' => 4.8,'reviewCount' => 2100,'size' => 'sm']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal077a61d60611f096a94f8e1725d6bb16)): ?>
<?php $attributes = $__attributesOriginal077a61d60611f096a94f8e1725d6bb16; ?>
<?php unset($__attributesOriginal077a61d60611f096a94f8e1725d6bb16); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal077a61d60611f096a94f8e1725d6bb16)): ?>
<?php $component = $__componentOriginal077a61d60611f096a94f8e1725d6bb16; ?>
<?php unset($__componentOriginal077a61d60611f096a94f8e1725d6bb16); ?>
<?php endif; ?>
        
        
        <?php if($post->excerpt): ?>
            <p class="text-[#E0E0E0]/80 text-sm leading-relaxed line-clamp-3"><?php echo e($post->excerpt); ?></p>
        <?php endif; ?>
        
        
        <?php if(!empty($pros)): ?>
            <div class="pt-4 border-t border-gray-800">
                <h4 class="text-sm font-semibold text-cyan-400 mb-3">Key Benefits:</h4>
                <ul class="space-y-2">
                    <?php $__currentLoopData = $pros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="flex items-start text-sm text-[#E0E0E0]/80">
                            
                            <svg class="w-5 h-5 text-green-400 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            <span><?php echo e($pro); ?></span>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        
        
        <p class="text-xs text-center text-[#E0E0E0]/50 mt-4">
            ✓ Secure Checkout • ✓ Money-Back Guarantee
        </p>
    </div>
<?php endif; ?>

<?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/components/affiliate-card.blade.php ENDPATH**/ ?>