<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" x-data="{ darkMode: localStorage.getItem('darkMode') === 'true' || true }" :class="{ 'dark': darkMode }">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
    <script>
        (function() {
            // Check localStorage for dark mode preference (default to dark)
            const darkMode = localStorage.getItem('darkMode') !== 'false';
            
            // Apply dark class immediately before page renders
            if (darkMode) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        })();
    </script>

    <title><?php echo $__env->yieldContent('title', 'Admin Dashboard'); ?> - <?php echo e(config('app.name', 'Linkie.dev')); ?></title>

    <!-- Google Fonts - Inter & Poppins for modern typography -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    
    <style>
        /* Prevent white flash - default to dark mode */
        html {
            color-scheme: dark;
        }
        /* Default dark background - will be overridden by Tailwind when it loads */
        body {
            background-color: #111827 !important; /* gray-900 */
            color: #F3F4F6 !important; /* gray-100 */
            margin: 0;
            padding: 0;
        }
        /* When light mode is explicitly set */
        html:not(.dark) body {
            background-color: #F9FAFB !important; /* gray-50 */
            color: #111827 !important; /* gray-900 */
        }
        /* Ensure dark mode body stays dark */
        html.dark body {
            background-color: #111827 !important;
            color: #F3F4F6 !important;
        }
    </style>
    
    <!-- Alpine.js for reactive UI -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="font-sans antialiased bg-gray-50 dark:bg-gray-900 text-gray-900 dark:text-gray-100 transition-colors duration-200" 
      x-bind:class="darkMode ? 'dark' : ''">
    
    <div class="min-h-screen flex" x-data="{ sidebarOpen: window.innerWidth >= 1024 }">
        <!-- Sidebar -->
        <?php echo $__env->make('admin.components.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Main Content Area -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Header -->
            <?php echo $__env->make('admin.components.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            
            <!-- Page Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 dark:bg-gray-900 p-6 lg:p-8">
                <!-- Flash Messages -->
                <?php echo $__env->make('admin.components.flash-messages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                
                <!-- Page Header -->
                <?php if (! empty(trim($__env->yieldContent('page-header')))): ?>
                    <div class="mb-6">
                        <?php echo $__env->yieldContent('page-header'); ?>
                    </div>
                <?php endif; ?>
                
                <!-- Main Content -->
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>
    
    <!-- Modals -->
    <?php echo $__env->yieldPushContent('modals'); ?>
    
    <!-- Scripts -->
    <?php echo $__env->yieldPushContent('scripts'); ?>
    
    <script>
        // Theme persistence and sync
        document.addEventListener('alpine:init', () => {
            const isDark = localStorage.getItem('darkMode') !== 'false';
            
            Alpine.store('theme', {
                dark: isDark,
                toggle() {
                    this.dark = !this.dark;
                    localStorage.setItem('darkMode', this.dark);
                    // Immediately update HTML class
                    document.documentElement.classList.toggle('dark', this.dark);
                }
            });
            
            // Ensure HTML class is synced on init
            document.documentElement.classList.toggle('dark', isDark);
        });
    </script>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>