

<?php $__env->startSection('title', $post->meta_title ?? $post->title . ' - Linkie.dev'); ?>

<?php $__env->startSection('meta'); ?>


<meta name="description" content="<?php echo e($post->meta_description ?? $post->excerpt ?? 'Read this article on Linkie.dev'); ?>">

<link rel="canonical" href="<?php echo e(url()->current()); ?>">

<meta property="og:title" content="<?php echo e($post->meta_title ?? $post->title); ?>">
<meta property="og:description" content="<?php echo e($post->meta_description ?? $post->excerpt ?? ''); ?>">
<meta property="og:type" content="article">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<?php if($post->featured_image): ?>

<meta property="og:image" content="<?php echo e(url(Storage::url($post->featured_image))); ?>">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<?php endif; ?>

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($post->meta_title ?? $post->title); ?>">
<meta name="twitter:description" content="<?php echo e($post->meta_description ?? $post->excerpt ?? ''); ?>">
<?php if($post->featured_image): ?>

<meta name="twitter:image" content="<?php echo e(url(Storage::url($post->featured_image))); ?>">
<?php endif; ?>

<?php if($post->published_at): ?>
<meta property="article:published_time" content="<?php echo e($post->published_at->toIso8601String()); ?>">
<?php endif; ?>
<?php if($post->category): ?>
<meta property="article:section" content="<?php echo e($post->category); ?>">
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<article class="py-12 bg-[#121212]">
    
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <a href="<?php echo e(route('blog.index')); ?>" class="inline-flex items-center text-[#00B4D8] hover:text-[#00B4D8]/80 mb-8 transition-colors">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
            </svg>
            Back to Blog
        </a>

        
        <?php if($post->featured_image): ?>
            <div class="mb-8 rounded-xl overflow-hidden shadow-2xl">
                <img src="<?php echo e(Storage::url($post->featured_image)); ?>" 
                     alt="<?php echo e($post->title); ?>"
                     class="w-full h-auto">
            </div>
        <?php endif; ?>

        
        <div class="grid grid-cols-1 xl:grid-cols-4 gap-10">
            
            <div class="xl:col-span-3 space-y-8">
                
                <header class="space-y-4">
                    
                    <?php if($post->category && strtolower($post->category) !== 'imported'): ?>
                        <span class="inline-block px-4 py-2 text-sm font-semibold text-[#00B4D8] bg-[#00B4D8]/10 rounded-full">
                            <?php echo e($post->category); ?>

                        </span>
                    <?php endif; ?>
                    
                    
                    <h1 class="text-4xl md:text-5xl lg:text-6xl font-black font-heading text-white leading-tight">
                        <?php echo e($post->title); ?>

                    </h1>

                    
                    <div class="flex flex-wrap items-center gap-6 text-[#E0E0E0]/70 text-sm">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            <span><?php echo e($post->published_at?->format('F d, Y') ?? $post->created_at->format('F d, Y')); ?></span>
                        </div>
                        
                        <?php if (isset($component)) { $__componentOriginal077a61d60611f096a94f8e1725d6bb16 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal077a61d60611f096a94f8e1725d6bb16 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.rating-stars','data' => ['rating' => 4.8,'reviewCount' => 2100,'size' => 'sm']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('rating-stars'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['rating' => 4.8,'reviewCount' => 2100,'size' => 'sm']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal077a61d60611f096a94f8e1725d6bb16)): ?>
<?php $attributes = $__attributesOriginal077a61d60611f096a94f8e1725d6bb16; ?>
<?php unset($__attributesOriginal077a61d60611f096a94f8e1725d6bb16); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal077a61d60611f096a94f8e1725d6bb16)): ?>
<?php $component = $__componentOriginal077a61d60611f096a94f8e1725d6bb16; ?>
<?php unset($__componentOriginal077a61d60611f096a94f8e1725d6bb16); ?>
<?php endif; ?>
                    </div>
                </header>

                
                <?php
                    // Get affiliate link from database field first, then extract from content as fallback
                    $affiliateLink = $post->affiliate_link ?? '';
                    $ctaText = $post->cta_section ?? '';
                    
                    // If not in database, try to extract from content
                    if (empty($affiliateLink) || empty($ctaText)) {
                        $content = html_entity_decode($post->content, ENT_QUOTES | ENT_HTML5, 'UTF-8');
                        
                        // Extract affiliate link from content if not in database
                        if (empty($affiliateLink)) {
                            // First, try to extract from cta-section div (most reliable)
                            if (preg_match('/<div[^>]*class=["\']cta-section["\'][^>]*>.*?<a[^>]*href=["\']([^"\']+)["\'][^>]*>/s', $content, $matches)) {
                                $affiliateLink = $matches[1];
                            }
                            // If not found in cta-section, try any link with target="_blank" and rel="nofollow"
                            if (empty($affiliateLink)) {
                                if (preg_match('/<a[^>]*href=["\']([^"\']+)["\'][^>]*(?:target=["\']_blank["\']|rel=["\']nofollow["\'])/s', $content, $matches)) {
                                    $affiliateLink = $matches[1];
                                }
                            }
                            // Last resort: any link with target="_blank"
                            if (empty($affiliateLink)) {
                                if (preg_match('/<a[^>]*href=["\']([^"\']+)["\'][^>]*target=["\']_blank["\']/s', $content, $matches)) {
                                    $affiliateLink = $matches[1];
                                }
                            }
                            // Final fallback: extract any external URL from anchor tags (http/https)
                            if (empty($affiliateLink)) {
                                if (preg_match_all('/<a[^>]*href=["\'](https?:\/\/[^"\']+)["\'][^>]*>/s', $content, $allMatches)) {
                                    // Take the first external URL found
                                    foreach ($allMatches[1] as $url) {
                                        // Skip internal links and common non-affiliate domains
                                        if (!preg_match('/\.(jpg|jpeg|png|gif|pdf|zip)$/i', $url) && 
                                            !preg_match('/^(mailto:|tel:|#)/', $url)) {
                                            $affiliateLink = $url;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        
                        // Extract CTA text from content if not in database
                        if (empty($ctaText)) {
                            if (preg_match('/<div[^>]*class=["\']cta-section["\'][^>]*>.*?<h2[^>]*>(.*?)<\/h2>/s', $content, $ctaMatches)) {
                                $ctaText = strip_tags($ctaMatches[1]);
                            }
                        }
                    }
                ?>
                
                <?php if(!empty($affiliateLink) && filter_var($affiliateLink, FILTER_VALIDATE_URL)): ?>
                    <?php if (isset($component)) { $__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.cta-block','data' => ['link' => $affiliateLink,'text' => $ctaText,'title' => $post->title]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('cta-block'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['link' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($affiliateLink),'text' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($ctaText),'title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($post->title)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0)): ?>
<?php $attributes = $__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0; ?>
<?php unset($__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0)): ?>
<?php $component = $__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0; ?>
<?php unset($__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0); ?>
<?php endif; ?>
                <?php endif; ?>

                
                <?php
                    // Ensure content is decoded for parsing
                    $content = html_entity_decode($post->content, ENT_QUOTES | ENT_HTML5, 'UTF-8');
                    
                    // Extract Pros
                    $pros = [];
                    if (preg_match('/<h2>Pros<\/h2><ul>(.*?)<\/ul>/s', $content, $matches)) {
                        preg_match_all('/<li>(.*?)<\/li>/', $matches[1], $proMatches);
                        $pros = array_map('strip_tags', $proMatches[1]);
                    }
                    
                    // Extract Cons
                    $cons = [];
                    if (preg_match('/<h2>Cons<\/h2><ul>(.*?)<\/ul>/s', $content, $matches)) {
                        preg_match_all('/<li>(.*?)<\/li>/', $matches[1], $conMatches);
                        $cons = array_map('strip_tags', $conMatches[1]);
                    }
                    
                    // Extract Features
                    $features = [];
                    if (preg_match('/<h2>Features<\/h2><ul>(.*?)<\/ul>/s', $content, $matches)) {
                        preg_match_all('/<li>(.*?)<\/li>/', $matches[1], $featureMatches);
                        $features = array_map('strip_tags', $featureMatches[1]);
                    }
                    
                    // Extract FAQs
                    $faqs = [];
                    if (preg_match('/<h2>Frequently Asked Questions<\/h2>(.*?)(?=<h2|$)/s', $content, $faqSection)) {
                        preg_match_all('/<h3>(.*?)<\/h3>\s*<p>(.*?)<\/p>/s', $faqSection[1], $faqMatches);
                        for ($i = 0; $i < count($faqMatches[1]); $i++) {
                            $faqs[] = [
                                'question' => strip_tags($faqMatches[1][$i]),
                                'answer' => strip_tags($faqMatches[2][$i])
                            ];
                        }
                    }
                    
                    // Remove pros/cons/features/faqs/cta sections from main content for cleaner display
                    // But keep the headings for TOC generation
                    $cleanContent = $content;
                    $cleanContent = preg_replace('/<h2>Pros<\/h2><ul>.*?<\/ul>/s', '', $cleanContent);
                    $cleanContent = preg_replace('/<h2>Cons<\/h2><ul>.*?<\/ul>/s', '', $cleanContent);
                    $cleanContent = preg_replace('/<h2>Features<\/h2><ul>.*?<\/ul>/s', '', $cleanContent);
                    $cleanContent = preg_replace('/<h2>Frequently Asked Questions<\/h2>.*?(?=<h2|$)/s', '', $cleanContent);
                    $cleanContent = preg_replace('/<div class="cta-section"[^>]*>.*?<\/div>/s', '', $cleanContent);
                    
                    // Ensure content is properly decoded (handle double encoding)
                    $cleanContent = html_entity_decode($cleanContent, ENT_QUOTES | ENT_HTML5, 'UTF-8');
                ?>

                
                <div class="my-8 p-6 bg-[#1D1D1D] border border-gray-700 rounded-xl">
                    <h3 class="text-xl font-bold text-cyan-300 mb-4 flex items-center">
                        <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                        Table of Contents
                    </h3>
                    <ul class="space-y-2 text-[#E0E0E0] text-base" id="toc-list">
                        
                    </ul>
                </div>

                
                <div class="prose prose-invert prose-lg max-w-none text-[#E0E0E0] article-content">
                    <?php echo $cleanContent; ?>

                </div>

                
                <?php if(!empty($pros) || !empty($cons)): ?>
                    <div class="grid md:grid-cols-2 gap-6 my-10">
                        
                        <?php if(!empty($pros)): ?>
                            <div id="pros-section" class="bg-[#1A1A1A] p-6 rounded-xl border border-green-500/20 shadow-lg">
                                <h3 class="text-green-400 text-xl font-bold mb-4 flex items-center">
                                    <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    Pros
                                </h3>
                                <ul class="space-y-3 list-none">
                                    <?php $__currentLoopData = $pros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="flex items-start text-[#E0E0E0]">
                                            <svg class="w-5 h-5 text-green-400 mr-3 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                            </svg>
                                            <span><?php echo e($pro); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        
                        <?php if(!empty($cons)): ?>
                            <div id="cons-section" class="bg-[#1A1A1A] p-6 rounded-xl border border-red-500/20 shadow-lg">
                                <h3 class="text-red-400 text-xl font-bold mb-4 flex items-center">
                                    <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    Cons
                                </h3>
                                <ul class="space-y-3 list-none">
                                    <?php $__currentLoopData = $cons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $con): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="flex items-start text-[#E0E0E0]">
                                            <svg class="w-5 h-5 text-red-400 mr-3 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                            </svg>
                                            <span><?php echo e($con); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                
                <?php if(!empty($features)): ?>
                    <div id="features-section" class="my-10 bg-[#1A1A1A] p-6 rounded-xl border border-gray-800 shadow-lg">
                        <h3 class="text-2xl font-bold text-cyan-300 mb-6 flex items-center">
                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                            Key Features
                        </h3>
                        <div class="grid md:grid-cols-2 gap-4">
                            <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-start text-[#E0E0E0]">
                                    <svg class="w-5 h-5 text-cyan-400 mr-3 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                    </svg>
                                    <span><?php echo e($feature); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(!empty($affiliateLink) && filter_var($affiliateLink, FILTER_VALIDATE_URL)): ?>
                    <?php if (isset($component)) { $__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.cta-block','data' => ['link' => $affiliateLink,'text' => $ctaText,'title' => $post->title]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('cta-block'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['link' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($affiliateLink),'text' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($ctaText),'title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($post->title)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0)): ?>
<?php $attributes = $__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0; ?>
<?php unset($__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0)): ?>
<?php $component = $__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0; ?>
<?php unset($__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0); ?>
<?php endif; ?>
                <?php endif; ?>

                
                <?php if(!empty($faqs)): ?>
                    <div id="faqs-section">
                        <?php if (isset($component)) { $__componentOriginal5d1e16bf605b55f667e923c5493c639b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5d1e16bf605b55f667e923c5493c639b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.faq-accordion','data' => ['faqs' => $faqs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('faq-accordion'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['faqs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($faqs)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5d1e16bf605b55f667e923c5493c639b)): ?>
<?php $attributes = $__attributesOriginal5d1e16bf605b55f667e923c5493c639b; ?>
<?php unset($__attributesOriginal5d1e16bf605b55f667e923c5493c639b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5d1e16bf605b55f667e923c5493c639b)): ?>
<?php $component = $__componentOriginal5d1e16bf605b55f667e923c5493c639b; ?>
<?php unset($__componentOriginal5d1e16bf605b55f667e923c5493c639b); ?>
<?php endif; ?>
                    </div>
                <?php endif; ?>

                
                <?php if($relatedPosts->count() > 0): ?>
                    <section class="mt-16 pt-16 border-t border-gray-800">
                        <h2 class="text-3xl font-bold font-heading text-white mb-8">Related Articles</h2>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <?php $__currentLoopData = $relatedPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedPost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if (isset($component)) { $__componentOriginalef84dbe2113ee1aa06beffddb73fe07d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blog-card','data' => ['post' => $relatedPost]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blog-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['post' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($relatedPost)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d)): ?>
<?php $attributes = $__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d; ?>
<?php unset($__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalef84dbe2113ee1aa06beffddb73fe07d)): ?>
<?php $component = $__componentOriginalef84dbe2113ee1aa06beffddb73fe07d; ?>
<?php unset($__componentOriginalef84dbe2113ee1aa06beffddb73fe07d); ?>
<?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </section>
                <?php else: ?>
                    
                    <?php
                        $recentPosts = \App\Models\Post::published()
                            ->where('id', '!=', $post->id)
                            ->latest('published_at')
                            ->limit(3)
                            ->get();
                    ?>
                    <?php if($recentPosts->count() > 0): ?>
                        <section class="mt-16 pt-16 border-t border-gray-800">
                            <h2 class="text-3xl font-bold font-heading text-white mb-8">Latest Articles</h2>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <?php $__currentLoopData = $recentPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentPost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if (isset($component)) { $__componentOriginalef84dbe2113ee1aa06beffddb73fe07d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blog-card','data' => ['post' => $recentPost]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blog-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['post' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($recentPost)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d)): ?>
<?php $attributes = $__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d; ?>
<?php unset($__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalef84dbe2113ee1aa06beffddb73fe07d)): ?>
<?php $component = $__componentOriginalef84dbe2113ee1aa06beffddb73fe07d; ?>
<?php unset($__componentOriginalef84dbe2113ee1aa06beffddb73fe07d); ?>
<?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </section>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            
            <div class="xl:col-span-1 space-y-6">
                
                <?php if(!empty($affiliateLink) && filter_var($affiliateLink, FILTER_VALIDATE_URL)): ?>
                    <?php if (isset($component)) { $__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.cta-block','data' => ['link' => $affiliateLink,'text' => $ctaText,'title' => $post->title]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('cta-block'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['link' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($affiliateLink),'text' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($ctaText),'title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($post->title)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0)): ?>
<?php $attributes = $__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0; ?>
<?php unset($__attributesOriginalfa699b9e8bc2985ce79b438cc5fe13b0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0)): ?>
<?php $component = $__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0; ?>
<?php unset($__componentOriginalfa699b9e8bc2985ce79b438cc5fe13b0); ?>
<?php endif; ?>
                <?php endif; ?>
                
                
                <?php if (isset($component)) { $__componentOriginalf42874b176b75021aa662e243c597a8f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf42874b176b75021aa662e243c597a8f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.affiliate-card','data' => ['post' => $post]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('affiliate-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['post' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($post)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf42874b176b75021aa662e243c597a8f)): ?>
<?php $attributes = $__attributesOriginalf42874b176b75021aa662e243c597a8f; ?>
<?php unset($__attributesOriginalf42874b176b75021aa662e243c597a8f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf42874b176b75021aa662e243c597a8f)): ?>
<?php $component = $__componentOriginalf42874b176b75021aa662e243c597a8f; ?>
<?php unset($__componentOriginalf42874b176b75021aa662e243c597a8f); ?>
<?php endif; ?>
            </div>
        </div>
    </div>
</article>

<?php $__env->startPush('scripts'); ?>
<script>
    // Table of Contents Generator: Auto-generate TOC from article headings
    document.addEventListener('DOMContentLoaded', function() {
        const articleContent = document.querySelector('.article-content');
        const tocList = document.getElementById('toc-list');
        const tocContainer = tocList?.closest('.my-8');
        
        if (!articleContent || !tocList) return;
        
        // Find all h2 and h3 headings in the article content
        const headings = articleContent.querySelectorAll('h2, h3');
        
        // Also check for Pros, Cons, Features, FAQs sections
        const prosSection = document.querySelector('#pros-section');
        const consSection = document.querySelector('#cons-section');
        const featuresSection = document.querySelector('#features-section');
        const faqsSection = document.querySelector('#faqs-section');
        
        // Collect all headings
        const allHeadings = Array.from(headings);
        
        // Add section headings if they exist
        if (prosSection) {
            const h2 = document.createElement('h2');
            h2.id = 'toc-pros';
            h2.textContent = 'Pros';
            prosSection.insertBefore(h2, prosSection.firstChild);
            allHeadings.push(h2);
        }
        if (consSection) {
            const h2 = document.createElement('h2');
            h2.id = 'toc-cons';
            h2.textContent = 'Cons';
            consSection.insertBefore(h2, consSection.firstChild);
            allHeadings.push(h2);
        }
        if (featuresSection) {
            const h2 = document.createElement('h2');
            h2.id = 'toc-features';
            h2.textContent = 'Features';
            featuresSection.insertBefore(h2, featuresSection.firstChild);
            allHeadings.push(h2);
        }
        if (faqsSection) {
            const h2 = document.createElement('h2');
            h2.id = 'toc-faqs';
            h2.textContent = 'Frequently Asked Questions';
            faqsSection.insertBefore(h2, faqsSection.firstChild);
            allHeadings.push(h2);
        }
        
        if (allHeadings.length === 0) {
            // Hide TOC if no headings found
            if (tocContainer) tocContainer.style.display = 'none';
            return;
        }
        
        // Process each heading
        allHeadings.forEach((heading, index) => {
            // Generate unique ID for each heading if it doesn't have one
            if (!heading.id) {
                const id = 'heading-' + index + '-' + heading.textContent.trim().toLowerCase()
                    .replace(/[^a-z0-9]+/g, '-')
                    .replace(/^-|-$/g, '');
                heading.id = id;
            }
            
            // Create TOC item
            const li = document.createElement('li');
            const isH3 = heading.tagName === 'H3';
            
            li.className = isH3 ? 'ml-4 text-sm' : '';
            li.innerHTML = `<a href="#${heading.id}" class="text-cyan-400 hover:text-cyan-300 hover:underline transition-colors">${heading.textContent.trim()}</a>`;
            
            tocList.appendChild(li);
        });
        
        // Smooth scroll for TOC links
        tocList.querySelectorAll('a').forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                const targetId = this.getAttribute('href').substring(1);
                const targetElement = document.getElementById(targetId);
                if (targetElement) {
                    // Add offset for fixed header if needed
                    const offset = 100;
                    const elementPosition = targetElement.getBoundingClientRect().top;
                    const offsetPosition = elementPosition + window.pageYOffset - offset;
                    
                    window.scrollTo({
                        top: offsetPosition,
                        behavior: 'smooth'
                    });
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/blog/show.blade.php ENDPATH**/ ?>