import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';
import typography from '@tailwindcss/typography';

/** @type {import('tailwindcss').Config} */
export default {
    darkMode: 'class', // Enable class-based dark mode
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.blade.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            // Font Families: Inter/Montserrat/Cairo for bold typography
            fontFamily: {
                sans: ['Inter', 'Cairo', ...defaultTheme.fontFamily.sans],
                heading: ['Montserrat', 'Inter', 'Cairo', ...defaultTheme.fontFamily.sans],
            },
            // Custom Color Palette: Dark Mode Tech Theme
            colors: {
                // Dark background colors
                'dark-bg': {
                    DEFAULT: '#121212',      // Main dark background
                    'darker': '#0a0a0a',     // Even darker for contrast sections
                    'card': '#1a1a1a',        // Card backgrounds
                },
                // Text colors
                'dark-text': {
                    DEFAULT: '#E0E0E0',       // Primary text color
                    'muted': '#E0E0E0/70',   // Muted text (70% opacity)
                    'dim': '#E0E0E0/50',     // Dim text (50% opacity)
                },
                // Accent colors
                'accent': {
                    DEFAULT: '#00B4D8',     // Cyan accent for CTAs and hover
                    'dark': '#1E3A8A',       // Darker blue accent for contrast
                    'hover': '#00B4D8/80',   // Hover state (80% opacity)
                },
            },
        },
    },

    plugins: [forms, typography],
};
